import { Injectable } from '@nestjs/common';
import type { ErnieBotAccessToken, ErnieBotChatResponse } from './types';
import { ChatQueryDto } from './dto/chatQuery.dto';
import axios from 'axios';
import retry from 'axios-retry'

retry(axios, {
  retries: 3,
  retryDelay: retry.exponentialDelay
})

@Injectable()
export class ChatService {
  private static readonly AXIOS_TIME_OUT = 1000 * 60 * 5
  /**
   *  查询问题
   * @param body ChatQueryDto
   * @returns 
   */
  async query(body: ChatQueryDto) {
    return await this.chat(body)
  }

  /**
   * 问题是否缺失
   * @param query 问题
   */
  private queryIsMissed(query: string) {

  }


  /**
   * 向千帆大模型提交问题
   * @param param ChatQueryDto
   * @returns 
   */
  private async chat({query, history}: ChatQueryDto) {
    const url = `${process.env.ERNIE_BOT_KNOWLEDGE_PLUGIN_URL}?access_token=${await this.getAccessToken()}`
    const data = JSON.stringify({
      query,
      plugins: ['uuid-zhishiku'],
      verbose: true,
      history,
    })
    const res = await axios<ErnieBotChatResponse>(url, { method: 'post', timeout: ChatService.AXIOS_TIME_OUT, headers: { 'Content-Type': 'application/json' }, data })
    return res.data.result || res.data.error_msg
  }

  /**
   * 获取百度access_token
   * @returns 获取百度token
   */
  private async getAccessToken() {
    const AK = process.env.ERNIE_BOT_AK
    const SK = process.env.ERNIE_BOT_SK
    const res = await axios<ErnieBotAccessToken>(`${process.env.ERNIE_BOT_ACCESS_TOKEN_URL}&client_id=${AK}&client_secret=${SK}`, {
      method: 'post',
      timeout: ChatService.AXIOS_TIME_OUT
    })
    return res.data.access_token
  }
}
