import { Module } from '@nestjs/common';
import { ConfigModule } from '@nestjs/config';
import { AppController } from './app.controller';
import { AppService } from './app.service';
import { AuthModule } from './modules/auth/auth.module';
import { ChatController } from './modules/chat/chat.controller';
import { ChatModule } from './modules/chat/chat.module';
import envConfig from './config/env';

@Module({
  imports: [ ConfigModule.forRoot({
    isGlobal: true,
    envFilePath: [envConfig.path],
  }), AuthModule, ChatModule],
  controllers: [AppController, ChatController],
  providers: [AppService],
})
export class AppModule {}
