import { ApiPropertyOptional } from '@nestjs/swagger';
import { Type } from 'class-transformer';
import { IsArray, IsNotEmpty, ValidateNested, IsString, IsIn, IsDefined, IsObject } from "class-validator"

class HistoryItemDto {
  @IsDefined()
  @IsString()
  @IsNotEmpty()
  @IsIn(['user', 'assistant'])
  @ApiPropertyOptional({description: '角色 user assistant'})
  role: number;
  
  @IsDefined()
  @IsString()
  @IsNotEmpty()
  @ApiPropertyOptional({description: '内容'})
  content: string;
}

export class ChatQueryDto {
  @IsArray()
  @IsObject({ each: true })
  @ValidateNested({each: true})
  @Type(() => HistoryItemDto)
  @ApiPropertyOptional({description: '聊天记录', type: [HistoryItemDto]})
  public readonly history: HistoryItemDto[]

  @IsNotEmpty()
  @IsString()
  @ApiPropertyOptional({description: '查询信息'})
  public readonly query: string
}
