import { ChatService } from './chat.service';
import { Body, Controller, HttpException, HttpStatus, Post, Req } from '@nestjs/common';
import { ApiOperation, ApiTags } from '@nestjs/swagger';
import { ChatQueryDto } from './dto/chatQuery.dto';

@ApiTags('chat')
@Controller('chat')
export class ChatController {
  constructor(private readonly chatService: ChatService) {}
  
  @ApiOperation({ summary: '查询答案', description: '向ERNIE Bot模型发送消息得到答案' })
  @Post('query')
  query(@Body() body: ChatQueryDto) {
    try {
      return this.chatService.query(body)
    } catch (error) {
      new HttpException({ message: '服务端错误 ', error: error }, HttpStatus.BAD_REQUEST)
    }
  }
}
