import { ApiPropertyOptional } from '@nestjs/swagger';
import { IsArray, ArrayMinSize } from "class-validator"

export interface Message {
  role: 'user' | 'admin'
  content: string
}
export class sendMessageDto {
  @IsArray({message: '消息数组必须是数组'})  
  @ArrayMinSize(1, {message: '消息数组长度最小为1'})
  @ApiPropertyOptional({ description: '消息数组', example: [{ role: 'user', content: '你好' }] })
  public readonly messages: Message[]
}
