import { ChatService } from './chat.service';
import { Body, Controller, HttpException, HttpStatus, Post, Req } from '@nestjs/common';
import { ApiOperation, ApiTags } from '@nestjs/swagger';
import { sendMessageDto } from './dto/sendMessage.dto';

@ApiTags('chat')
@Controller('chat')
export class ChatController {
  constructor(private readonly chatService: ChatService) {}
  
  @ApiOperation({ summary: '发送消息', description: '向ERNIE Bot模型发送消息得到答案' })
  @Post('sendMessage')
  sendMessage(@Body() body: sendMessageDto) {
    try {
      return this.chatService.sendMessage(body.messages)
    } catch (error) {
      new HttpException({ message: '服务端错误 ', error: error }, HttpStatus.BAD_REQUEST)
    }
  }
}
