
export type HistoryItemRole = 'user' | 'assistant'

export interface HistoryItem {
  role: HistoryItemRole
  content: string
}

export type History = HistoryItem[]

interface ErnieBotChatUsage {
  prompt_tokens: number
  completion_tokens: number
  total_tokens: number
}


export interface ErnieBotChatResponse {
  id: string
  object: string
  created: number
  result: string
  is_truncated: boolean
  need_clear_history: boolean
  finish_reason: string
  usage: ErnieBotChatUsage
  error_msg: string
}

export interface ErnieBotAccessToken {
  refresh_token: string
  expires_in: number
  session_key: string
  access_token: string
  scope: string
  session_secret: string
}
