import { Injectable, Logger } from '@nestjs/common';
import axios from 'axios';
import retry from 'axios-retry'
import type { ErnieBotAccessToken, ErnieBotChatResponse } from './types';
import { ChatQueryDto } from './dto/chatQuery.dto';

const axiosTimeOut = 1000 * 60 * 5

retry(axios, {
  retries: 3,
  retryDelay: retry.exponentialDelay
})

@Injectable()
export class ChatService {
  async query(body: ChatQueryDto) {
    return await this.chat(body)
  }

  private async chat({query, history}: ChatQueryDto) {
    const url = `https://aip.baidubce.com/rpc/2.0/ai_custom/v1/wenxinworkshop/plugin/8yrkkifr8gccsvck/?access_token=${await this.getAccessToken()}`
    const data = JSON.stringify({
      query,
      plugins: ['uuid-zhishiku'],
      verbose: true,
      history,
    })
    const res = await axios<ErnieBotChatResponse>(url, { method: 'post', timeout: axiosTimeOut, headers: { 'Content-Type': 'application/json' }, data })
    return res.data.result || res.data.error_msg
  }

  private async getAccessToken() {
    const AK = 'mXQIDW260qBbNgQRF0p1YFgn'
    const SK = 'hzriOtzGiDkd1S0wFwiyr7WlarfufTdi'
    const res = await axios<ErnieBotAccessToken>(`https://aip.baidubce.com/oauth/2.0/token?grant_type=client_credentials&client_id=${AK}&client_secret=${SK}`, {
      method: 'post',
      timeout: axiosTimeOut
    })
    return res.data.access_token
  }
}
